<?
/*
	PWS Upload Script - WU-PWS Upload protocol
	------------------------------------------
	Dit script kan gebruikt worden als custom upload url voor weerstations.
	Getest met de WS-5500
	(c) 2021 Vincent Lammens
*/
error_reporting(E_ALL);
ini_set('display_errors', 'on');

// Instellingen
$db_host = "localhost";
$db_name = "db_name";
$db_user = "db_username";
$db_pass = "password";
$db_table = "data";

$id = "weerstation"; // stationID
$key = "key"; // stationKey
// Einde instellingen

if (!isset($_GET["ID"])|| !isset($_GET["PASSWORD"])){
	die("Error: Je moet wel een ID/PASSWORD opgeven!");
} else {
	if ($_GET["ID"] != $id || $_GET['PASSWORD'] != $key){
		die("Error: Station ID of Statioon Key verkeerd");
	}
}

// lees megegeven parameters uit
$weather_data = $_GET;

// Conversie factoren
$f_mph_kmh = 1.60934;
$f_in_hpa = 33.86;
$f_in_mm = 25.4;

// Converteer temperaturen
@$weather_data['windchillc'] = round( ( $weather_data['windchillf'] - 32 ) * 5 / 9, 1 );
@$weather_data['indoortempc'] = round( ( $weather_data['indoortempf'] - 32 ) * 5 / 9, 1 );
@$weather_data['tempc'] = round( ( $weather_data['tempf'] - 32 ) * 5 / 9, 1 );
@$weather_data['dewptc'] = round( ( $weather_data['dewptf'] - 32 ) * 5 / 9, 1 );

// Converteer windsnelheid
@$weather_data['windgustkmh'] = round( $weather_data['windgustmph'] * $f_mph_kmh, 1 );
@$weather_data['windspeedkmh'] = round( $weather_data['windspeedmph'] * $f_mph_kmh, 1 );

// Converteer regenhoeveelheid
@$weather_data['rainmm'] = round( $weather_data['rainin'] * $f_in_mm, 2 );
@$weather_data['dailyrainmm'] = round( $weather_data['dailyrainin'] * $f_in_mm, 2 );
@$weather_data['weeklyrainmm'] = round( $weather_data['weeklyrainin'] * $f_in_mm, 2 );
@$weather_data['monthlyrainmm'] = round( $weather_data['monthlyrainin'] * $f_in_mm, 2 );

// Converteer luchtdruk
@$weather_data['baromhpa'] = round( $weather_data['baromin'] * $f_in_hpa, 2 ); // <----- Juiste waarde
@$weather_data['absbaromhpa'] = round( $weather_data['absbaromin'] * $f_in_hpa, 2 );

// Datum/tijd UTC
if ( $weather_data['dateutc'] == "now" ) {
		$weather_data['dateutc'] = gmdate("Y-m-d\TH:i:s\Z");
}

// Tijd in Europe/Brussels formaat
$date = new DateTime($_GET['dateutc'].'+00');
$date->setTimezone(new DateTimeZone('Europe/Brussels'));
@$weather_data['datelocal'] = $date->format('Y-m-d H:i:s');


try {
	$conn = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
	$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	// prepare sql and bind parameters
	$stmt = $conn->prepare("insert into $db_table(Tijd,Temperatuur,Dauwpunt,Windchill,Vochtigheid,Windsnelheid,WindstootSnelheid,Windrichting,Barometer,RegenVandaag,RegenIntensiteit,Zonnestraling,UV) values (:Tijd,:Temperatuur,:Dauwpunt,:Windchill,:Vochtigheid,:Windsnelheid,:WindstootSnelheid,:Windrichting,:Barometer,:RegenVandaag,:RegenIntensiteit,:Zonnestraling,:UV)");
	$stmt->bindParam(':Tijd',$weather_data["datelocal"]);
	$stmt->bindParam(':Temperatuur',$weather_data["tempc"]);
	$stmt->bindParam(':Dauwpunt',$weather_data["dewptc"]);
	$stmt->bindParam(':Windchill',$weather_data["windchillc"]);
	$stmt->bindParam(':Vochtigheid',$weather_data["humidity"]);
	$stmt->bindParam(':Windsnelheid',$weather_data["windspeedkmh"]);
	$stmt->bindParam(':WindstootSnelheid',$weather_data["windgustkmh"]);
	$stmt->bindParam(':Windrichting',$weather_data["winddir"]);
	$stmt->bindParam(':Barometer',$weather_data["baromhpa"]);
	$stmt->bindParam(':RegenVandaag',$weather_data["dailyrainmm"]);
	$stmt->bindParam(':RegenIntensiteit',$weather_data["rainmm"]);
	$stmt->bindParam(':Zonnestraling',$weather_data["solarradiation"]);
	$stmt->bindParam(':UV',$weather_data["UV"]);
	$stmt->execute();
	echo "New records created successfully";
} catch(PDOException $e) {
	echo "Error: " . $e->getMessage();
}
$conn = null;

die();


// Toon de data in JSON formaat -- Om te debuggen
$weather_data_json = json_encode($weather_data);
header('Content-Type: application/json');
echo($weather_data_json);

die(); // Beindig script.

?>
