<?php
/**
 * HWA data API
 * ------------
 * API om data beschikbaar te stellen op hetweeractueel.nl
 * speciaal in HTX formaat
*/

// Databank logingegevens
$db_host = "localhost";
$db_name = "db_name";
$db_user = "db_username";
$db_pass = "password";
$db_table = "data";


$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
};

$sql = "SELECT Temperatuur AS outsideTemp, Dauwpunt AS outsideDewPt, Windchill AS windChill, Vochtigheid AS outsideHumidity, WindstootSnelheid AS windSpeed, Windsnelheid AS wind10Avg, Windrichting AS windDir, Barometer AS barometer, RegenIntensiteit AS rainRate, RegenVandaag AS dailyRain, Zonnestraling AS solarRad, UV AS uv, time(Tijd) AS stationTime, date(Tijd) as stationDate FROM $db_table order by Tijd desc limit 1";

$result = $conn->query($sql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$stationDate = strftime("%d-%m-%y",strtotime($row['stationDate']));
		$stationTime = $row['stationTime'];
		$outsideTemp = $row['outsideTemp'];
		$outsideDewPt = $row['outsideDewPt'];
		$windChill = $row['windChill'];
		$outsideHumidity = $row['outsideHumidity'];
		$windSpeed = $row['windSpeed'];
		$wind10Avg = $row['wind10Avg'];
		$windDir = $row['windDir'];
		$barometer = $row['barometer'];
		$rainRate = $row['rainRate'];
		$dailyRain = $row['dailyRain'];
		$solarRad = $row['solarRad'];
		$uv = $row['uv'];

		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hitempsql = "select Temperatuur as hiOutsideTemp, time(Tijd) as hiOutsideTempTime from $db_table where Temperatuur = (select max(Temperatuur) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hitempsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiOutsideTemp = $row['hiOutsideTemp'];
		$hiOutsideTempTime = $row['hiOutsideTempTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$lowtempsql = "select Temperatuur as lowOutsideTemp, time(Tijd) as lowOutsideTempTime from $db_table where Temperatuur = (select min(Temperatuur) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($lowtempsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowOutsideTemp = $row['lowOutsideTemp'];
		$lowOutsideTempTime = $row['lowOutsideTempTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$lowhumiditysql = "select Vochtigheid as lowHumidity, time(Tijd) as lowHumTime from $db_table where Vochtigheid = (select min(Vochtigheid) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($lowhumiditysql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowHumidity = $row['lowHumidity'];
		$lowHumTime = $row['lowHumTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hihumiditysql = "select Vochtigheid as hiHumidity, time(Tijd) as hiHumTime from $db_table where Vochtigheid = (select max(Vochtigheid) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hihumiditysql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiHumidity = $row['hiHumidity'];
		$hiHumTime = $row['hiHumTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hidewpointsql = "select Dauwpunt as hiDewpoint, time(Tijd) as hiDewpointTime from $db_table where Dauwpunt = (select max(Dauwpunt) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hidewpointsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiDewpoint = $row['hiDewpoint'];
		$hiDewpointTime = $row['hiDewpointTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$lowdewpointsql = "select Dauwpunt as lowDewpoint, time(Tijd) as lowDewpointTime from $db_table where Dauwpunt = (select min(Dauwpunt) from $db_table where date(tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($lowdewpointsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowDewpoint = $row['lowDewpoint'];
		$lowDewpointTime = $row['lowDewpointTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hiwindspeedsql = "select WindstootSnelheid as hiWindSpeed, time(Tijd) as hiWindSpeedTime from $db_table where WindstootSnelheid = (select max(WindstootSnelheid) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hiwindspeedsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiWindSpeed = $row['hiWindSpeed'];
		$hiWindSpeedTime = $row['hiWindSpeedTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$lowwindchillsql = "select Windchill as lowWindchill, time(Tijd) as lowWindchillTime from $db_table where Windchill = (select min(Windchill) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($lowwindchillsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowWindchill = $row['lowWindchill'];
		$lowWindchillTime = $row['lowWindchillTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hibarometersql = "select Barometer as hiBarometer, time(Tijd) as hiBarometerTime from $db_table where Barometer = (select max(Barometer) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hibarometersql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiBarometer = $row['hiBarometer'];
		$hiBarometerTime = $row['hiBarometerTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$lowbarometersql = "select Barometer as lowBarometer, time(Tijd) as lowBarometerTime from $db_table where Barometer = (select min(Barometer) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($lowbarometersql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowBarometer = $row['lowBarometer'];
		$lowBarometerTime = $row['lowBarometerTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hirainratesql = "select RegenIntensiteit as hiRainRate, time(Tijd) as hiRainRateTime from $db_table where RegenIntensiteit = (select max(RegenIntensiteit) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hirainratesql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiRainRate = $row['hiRainRate'];
		$hiRainRateTime = $row['hiRainRateTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hisolarsql = "select Zonnestraling as hiSolarRad, time(Tijd) as hiSolarRadTime from $db_table where Zonnestraling = (select max(Zonnestraling) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hisolarsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiSolarRad = $row['hiSolarRad'];
		$hiSolarRadTime = $row['hiSolarRadTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$hiuvsql = "select UV as hiUV, time(Tijd) as hiUVTime from $db_table where UV = (select max(UV) from $db_table where date(Tijd) = CURRENT_DATE) order by Tijd desc limit 1";
$result = $conn->query($hiuvsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$hiUV = $row['hiUV'];
		$hiUVTime = $row['hiUVTime'];
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

$minmaxmaandsql = "SELECT MIN(Temperatuur) AS lowMonthlyOutsideTemp, MAX(Temperatuur) AS hiMonthlyOutsideTemp, MAX(Vochtigheid) AS hiMonthlyHumidity, MIN(Vochtigheid) AS lowMonthlyHumidity, MAX(Dauwpunt) AS hiMonthlyDewpoint, MIN(Dauwpunt) AS lowMonthlyDewpoint, MAX(WindstootSnelheid) AS hiMonthlyWindSpeed, MIN(Windchill) AS lowMonthlyWindchill, MIN(Barometer) AS lowMonthlyBarometer, MAX(Barometer) AS hiMonthlyBarometer, MAX(RegenIntensiteit) AS hiMonthlyRainRate, MAX(Zonnestraling) AS hiMonthlySolarRad, MAX(UV) AS hiMonthlyUV FROM $db_table WHERE MONTH(Tijd) = MONTH(CURRENT_DATE) AND year(Tijd) = year(CURRENT_DATE)";
$result = $conn->query($minmaxmaandsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$lowMonthlyOutsideTemp = $row['lowMonthlyOutsideTemp'];
		$hiMonthlyOutsideTemp = $row['hiMonthlyOutsideTemp'];
		$hiMonthlyHumidity = $row['hiMonthlyHumidity'];
		$lowMonthlyHumidity = $row['lowMonthlyHumidity'];
		$hiMonthlyDewpoint = $row['hiMonthlyDewpoint'];
		$lowMonthlyDewpoint = $row['lowMonthlyDewpoint'];
		$hiMonthlyWindSpeed = $row['hiMonthlyWindSpeed'];
		$lowMonthlyWindchill = $row['lowMonthlyWindchill'];
		$lowMonthlyBarometer = $row['lowMonthlyBarometer'];
		$hiMonthlyBarometer = $row['hiMonthlyBarometer'];
		$hiMonthlyRainRate = $row['hiMonthlyRainRate'];
		$hiMonthlySolarRad = $row['hiMonthlySolarRad'];
		$hiMonthlyUV = $row['hiMonthlyUV'];
		
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}
$monthlyrainsql = "select max(RegenVandaag) as regenval, date(tijd) from $db_table where month(Tijd) = month(CURRENT_DATE) and year(Tijd) = year(CURRENT_DATE) group by date(Tijd) order by date(Tijd)";
$monthlyRain = 0.00;
$result = $conn->query($monthlyrainsql);
if ($result->num_rows > 0) {
	// output data of each row
	while($row = $result->fetch_assoc()) {
		$monthlyRain += $row['regenval'];		
		//echo $timestamp.'@'.$temperature."\n"; 
	}
} else {
	$conn->close();
	http_response_code(500);
	die('Error: Serverfout');
}

// minmaxjaar word nog even genegeerd


// Data uitvoer
// Data is plain text
header('Content-Type: text/plain');
echo("BOF\n");
echo ('$stationDate = "'.$stationDate.'";'); echo ("\n");
echo ('$stationTime = "'.$stationTime.'";'); echo ("\n\n");

echo ('$date = "'.$stationDate.'";'); echo ("\n");
echo ('$time = "'.$stationTime.'";'); echo ("\n\n");

echo ('$tempUnit = "C";'); echo ("\n");
echo ('$humUnit = "%";'); echo ("\n");
echo ('$barUnit = "hPa";'); echo ("\n");
echo ('$rainUnit = "mm";'); echo ("\n");
echo ('$rateUnit = "mm/hr";'); echo ("\n");
echo ('$windUnit = "km/h";'); echo ("\n\n");

echo ('$outsideTemp = "'.$outsideTemp.'";'); echo ("\n");
echo ('$hiOutsideTemp = "'.$hiOutsideTemp.'";'); echo ("\n");
echo ('$lowOutsideTemp = "'.$lowOutsideTemp.'";'); echo ("\n\n");

echo ('$lowOutsideTempTime = "'.$lowOutsideTempTime.'";'); echo ("\n");
echo ('$hiOutsideTempTime = "'.$hiOutsideTempTime.'";'); echo ("\n\n");

echo ('$lowMonthlyOutsideTemp = "'.$lowMonthlyOutsideTemp.'";'); echo ("\n");
echo ('$hiMonthlyOutsideTemp = "'.$hiMonthlyOutsideTemp.'";'); echo ("\n\n");

echo ('$outsideHumidity = "'.$outsideHumidity.'";'); echo ("\n");
echo ('$lowHumidity = "'.$lowHumidity.'";'); echo ("\n");
echo ('$hiHumidity = "'.$hiHumidity.'";'); echo ("\n");
echo ('$lowHumTime = "'.$lowHumTime.'";'); echo ("\n");
echo ('$hiHumTime = "'.$hiHumTime.'";'); echo ("\n");
echo ('$hiMonthlyHumidity = "'.$hiMonthlyHumidity.'";'); echo ("\n");
echo ('$lowMonthlyHumidity = "'.$lowMonthlyHumidity.'";'); echo ("\n\n");

echo ('$outsideDewPt = "'.$outsideDewPt.'";'); echo ("\n");
echo ('$hiDewpoint = "'.$hiDewpoint.'";'); echo ("\n");
echo ('$lowDewpoint = "'.$lowDewpoint.'";'); echo ("\n");
echo ('$hiDewpointTime = "'.$hiDewpointTime.'";'); echo ("\n");
echo ('$lowDewpointTime = "'.$lowDewpointTime.'";'); echo ("\n");
echo ('$hiMonthlyDewpoint = "'.$hiMonthlyDewpoint.'";'); echo ("\n");
echo ('$lowMonthlyDewpoint = "'.$lowMonthlyDewpoint.'";'); echo ("\n\n");

echo ('$windSpeed = "'.$windSpeed.'";'); echo ("\n");
echo ('$wind10Avg = "'.$wind10Avg.'";'); echo ("\n");
echo ('$hiWindSpeed = "'.$hiWindSpeed.'";'); echo ("\n");
echo ('$hiWindSpeedTime = "'.$hiWindSpeedTime.'";'); echo ("\n");
echo ('$hiMonthlyWindSpeed = "'.$hiMonthlyWindSpeed.'";'); echo ("\n\n");

echo ('$windDir = "'.$windDir.'";'); echo ("\n");
echo ('$windDirection = "'.$windDir.'";'); echo ("\n\n");

echo ('$windChill = "'.$windChill.'";'); echo ("\n");
echo ('$lowWindchill = "'.$lowWindchill.'";'); echo ("\n");
echo ('$lowWindchillTime = "'.$lowWindchillTime.'";'); echo ("\n");
echo ('$lowMonthlyWindchill = "'.$lowMonthlyWindchill.'";'); echo ("\n\n");

echo ('$barometer = "'.$barometer.'";'); echo ("\n");
echo ('$lowBarometer = "'.$lowBarometer.'";'); echo ("\n");
echo ('$hiBarometer = "'.$hiBarometer.'";'); echo ("\n");
echo ('$lowMonthlyBarometer = "'.$lowMonthlyBarometer.'";'); echo ("\n");
echo ('$hiMonthlyBarometer = "'.$hiMonthlyBarometer.'";'); echo ("\n");
echo ('$lowBarometerTime = "'.$lowBarometerTime.'";'); echo ("\n");
echo ('$hiBarometerTime = "'.$hiBarometerTime.'";'); echo ("\n\n");

echo ('$dailyRain = "'.$dailyRain.'";'); echo ("\n");
echo ('$monthlyRain = "'.$monthlyRain.'";'); echo ("\n\n");

echo ('$rainRate = "'.$rainRate.'";'); echo ("\n");
echo ('$hiRainRate = "'.$hiRainRate.'";'); echo ("\n");
if ($hiRainRate == 0){
	$hiRainRateTime = '00:00:00';
}
echo ('$hiRainRateTime = "'.$hiRainRateTime.'";'); echo ("\n");
echo ('$hiMonthlyRainRate = "'.$hiMonthlyRainRate.'";'); echo ("\n\n");

echo ('$solarRad = "'.$solarRad.'";'); echo ("\n");
echo ('$hiSolarRad = "'.$hiSolarRad.'";'); echo ("\n");
echo ('$hiSolarRadTime = "'.$hiSolarRadTime.'";'); echo ("\n");
echo ('$hiMonthlySolarRad = "'.$hiMonthlySolarRad.'";'); echo ("\n\n");

echo ('$uv = "'.$uv.'";'); echo ("\n");
echo ('$hiUV = "'.$hiUV.'";'); echo ("\n");
echo ('$hiUVTime = "'.$hiUVTime.'";'); echo ("\n");
echo ('$hiMonthlyUV = "'.$hiMonthlyUV.'";'); echo ("\n\n");

echo ("EOF");
die();
$conn->close();
?>

